% Matteo Picchio
% Ancona 30/03/2017
                                   
function[NL, g, H]=function_f(b,n,kx1,X1,X2,X3,cens1,cens2,cens3,sam2,sam3,dur1_1,dur1_2,dur1_3,dur1_4,dur1_5,dur1_6,dur1_7,...
                                  dur2_1,dur2_2,dur2_3,dur2_4,dur2_5,dur2_6,dur3_1,dur3_2,dur3_3,W3,lab_ear3,kw3,W6,lab_ear6,samw6,...
                                  W9,lab_ear9,samw9,W12,lab_ear12,samw12,W15,lab_ear15,samw15,W18,lab_ear18,samw18,W21,lab_ear21,samw21,...
                                  Ze,Zs,kze,kzs,nsib,emp_1,totday3,totday6,totday9,totday12,totday15,totday18,totday21)
                              
% [g_b]=createFullGradients(b);

save('results\b.mat','b')
%--------------------------------------------------------------------------
%1.1 Assign b to 1st childbirth equation
%--------------------------------------------------------------------------
    bX1 = b(1:kx1,1);
    va1 = b(kx1+1,1);
    va2 = va1+exp(b(kx1+2,1));
    va3 = va2+exp(b(kx1+3,1));
    va4 = va3+exp(b(kx1+4,1));
    va5 = va4+exp(b(kx1+5,1));
    va6 = va5+exp(b(kx1+6,1));
    va7 = va6+exp(b(kx1+7,1));
    kh  = kx1+7;    
%--------------------------------------------------------------------------
%1.2 Assign b to 2nd childbirth equation
%--------------------------------------------------------------------------
    bX2 = [b(kh+1:kh+2,1); bX1];
    vb1 = b(kh+3,1);
    vb2 = vb1+exp(b(kh+4,1));
    vb3 = vb2+exp(b(kh+5,1));
    vb4 = vb3+exp(b(kh+6,1));
    vb5 = vb4+exp(b(kh+7,1));
    vb6 = vb5+exp(b(kh+8,1));
    kh  = kh+8;    
%--------------------------------------------------------------------------
%1.3 Assign b to 3rd childbirth equation
%--------------------------------------------------------------------------
    bX3 = [b(kh+1:kh+3,1); bX1];
    vc1 = b(kh+4,1);
    vc2 = vc1+exp(b(kh+5,1));
    vc3 = vc2+exp(b(kh+6,1));
    kh  = kh+6;    
%--------------------------------------------------------------------------
%1.4 Assign b to earnings equation 3 years after diploma
%--------------------------------------------------------------------------
    bW3 = [b(kh+1,1); b(kh+1,1); b(kh+1,1); b(kh+2:kh+kw3-2,1)];
    vw3_1 = b(kh+kw3-2+1,1);
    sig3 = b(kh+kw3-2+2,1);
    kh  = kh+kw3-2+2;    
%--------------------------------------------------------------------------
%1.5 Assign b to earnings equation 6 years after diploma
%--------------------------------------------------------------------------
    bW6   = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); bW3(4:kw3)];
    vw6_1 = b(kh+4,1);
    sig6  = b(kh+5,1);
    kh  = kh+5;    
%--------------------------------------------------------------------------
%1.6 Assign b to earnings equation 9 years after diploma
%--------------------------------------------------------------------------
    bW9   = [b(kh+1,1); b(kh+2,1); b(kh+3,1);... %timing to 1st kid 3-years intervals
             b(kh+4,1); b(kh+4,1); b(kh+5,1);... %timing to 2nd kid 3-years intervals
             b(kh+6,1); b(kh+6,1); b(kh+6,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw9_1 = b(kh+7,1);
    sig9  = b(kh+8,1);
    kh  = kh+8;    
%--------------------------------------------------------------------------
%1.7 Assign b to earnings equation 12 years after diploma
%--------------------------------------------------------------------------
    bW12  = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+4,1);... %timing to 1st kid 3-years intervals
             b(kh+5,1); b(kh+5,1); b(kh+6,1); b(kh+7,1);... %timing to 2nd kid 3-years intervals
             b(kh+8,1); b(kh+8,1); b(kh+8,1); b(kh+8,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw12_1= b(kh+9,1);
    sig12 = b(kh+10,1);
    kh  = kh+10;
%--------------------------------------------------------------------------
%1.8 Assign b to earnings equation 15 years after diploma
%--------------------------------------------------------------------------
    bW15  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1);... %timing to 1st kid 3-years intervals
             b(kh+6,1);  b(kh+6,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);... %timing to 2nd kid 3-years intervals
             b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+11,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw15_1= b(kh+12,1);
    sig15 = b(kh+13,1);
    kh  = kh+13;    
%--------------------------------------------------------------------------
%1.9 Assign b to earnings equation 18 years after diploma
%--------------------------------------------------------------------------
    bW18  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1) ;... %timing to 1st kid 3-years intervals
             b(kh+7,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1);... %timing to 2nd kid 3-years intervals
             b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+13,1); b(kh+14,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw18_1= b(kh+15,1);
    sig18 = b(kh+16,1);
    kh  = kh+16;    
%--------------------------------------------------------------------------
%1.10 Assign b to earnings equation 21 years after diploma
%--------------------------------------------------------------------------
    bW21  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1);  b(kh+7,1) ;... %timing to 1st kid 3-years intervals
             b(kh+8,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1); b(kh+12,1); b(kh+13,1);... %timing to 2nd kid 3-years intervals
             b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+15,1); b(kh+16,1); b(kh+16,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw21_1= b(kh+17,1);
    sig21 = b(kh+18,1);
    kh  = kh+18;  
%--------------------------------------------------------------------------
%1.11 Assign b to earnings equation 1 year before diploma
%--------------------------------------------------------------------------
    bZe   = b(kh+1:kh+kze,1);
    vze_1 = b(kh+kze+1,1);
    kh    = kh+kze+1;    
%--------------------------------------------------------------------------
%1.12 Assign b to siblings when 14 years old
%--------------------------------------------------------------------------
    bZs    = b(kh+1:kh+kzs,1);
    vzs_1  = b(kh+kzs+1,1);
    sig_zs = b(kh+kzs+2,1);
    kh    = kh+kzs+2;    

%--------------------------------------------------------------------------
%1.13 Assign b to employment equation 3 years after diploma
%--------------------------------------------------------------------------
    bE3 = [b(kh+1,1); b(kh+1,1); b(kh+1,1); b(kh+2:kh+kw3-2,1)];
    ve3_1 = b(kh+kw3-2+1,1);
    sigE3 = b(kh+kw3-2+2,1);
    kh  = kh+kw3-2+2;    
%--------------------------------------------------------------------------
%1.14 Assign b to employment equation 6 years after diploma
%--------------------------------------------------------------------------
    bE6   = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); bE3(4:kw3)];
    ve6_1 = b(kh+4,1);
    sigE6  = b(kh+5,1);
    kh  = kh+5;    
%--------------------------------------------------------------------------
%1.15 Assign b to employment equation 9 years after diploma
%--------------------------------------------------------------------------
    bE9   = [b(kh+1,1); b(kh+2,1); b(kh+3,1);... %timing to 1st kid 3-years intervals
             b(kh+4,1); b(kh+4,1); b(kh+5,1);... %timing to 2nd kid 3-years intervals
             b(kh+6,1); b(kh+6,1); b(kh+6,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve9_1 = b(kh+7,1);
    sigE9  = b(kh+8,1);
    kh  = kh+8;    
%--------------------------------------------------------------------------
%1.16 Assign b to employment equation 12 years after diploma
%--------------------------------------------------------------------------
    bE12  = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+4,1);... %timing to 1st kid 3-years intervals
             b(kh+5,1); b(kh+5,1); b(kh+6,1); b(kh+7,1);... %timing to 2nd kid 3-years intervals
             b(kh+8,1); b(kh+8,1); b(kh+8,1); b(kh+8,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve12_1= b(kh+9,1);
    sigE12 = b(kh+10,1);
    kh  = kh+10;
%--------------------------------------------------------------------------
%1.17 Assign b to employment equation 15 years after diploma
%--------------------------------------------------------------------------
    bE15  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1);... %timing to 1st kid 3-years intervals
             b(kh+6,1);  b(kh+6,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);... %timing to 2nd kid 3-years intervals
             b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+11,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve15_1= b(kh+12,1);
    sigE15 = b(kh+13,1);
    kh  = kh+13;    
%--------------------------------------------------------------------------
%1.18 Assign b to employment equation 18 years after diploma
%--------------------------------------------------------------------------
    bE18  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1) ;... %timing to 1st kid 3-years intervals
             b(kh+7,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1);... %timing to 2nd kid 3-years intervals
             b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+13,1); b(kh+14,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve18_1= b(kh+15,1);
    sigE18 = b(kh+16,1);
    kh  = kh+16;    
%--------------------------------------------------------------------------
%1.19 Assign b to employment equation 21 years after diploma
%--------------------------------------------------------------------------
    bE21  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1);  b(kh+7,1) ;... %timing to 1st kid 3-years intervals
             b(kh+8,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1); b(kh+12,1); b(kh+13,1);... %timing to 2nd kid 3-years intervals
             b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+15,1); b(kh+16,1); b(kh+16,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve21_1= b(kh+17,1);
    sigE21 = b(kh+18,1);
    kh  = kh+18;  

%--------------------------------------------------------------------------
%2.1 Contribution to the likelihood function of 1st childbirth
%--------------------------------------------------------------------------
lf1=ones(n,1);
lf1(:,1) = (  normcdf(va1 - X1*bX1).^dur1_1...
          .* (normcdf(va2 - X1*bX1)-normcdf(va1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3 - X1*bX1)-normcdf(va2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4 - X1*bX1)-normcdf(va3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5 - X1*bX1)-normcdf(va4 - X1*bX1)).^dur1_5...
          .* (normcdf(va6 - X1*bX1)-normcdf(va5 - X1*bX1)).^dur1_6...
          .* (normcdf(va7 - X1*bX1)-normcdf(va6 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7 - X1*bX1)).^dur1_7).^(cens1);
%--------------------------------------------------------------------------
%2.2 Contribution to the likelihood function of 2nd childbirth
%--------------------------------------------------------------------------
lf2=ones(n,1);
lf2(:,1) = (((  normcdf(vb1 - X2*bX2).^dur2_1...
           .* (normcdf(vb2 - X2*bX2)-normcdf(vb1 - X2*bX2)).^dur2_2...
           .* (normcdf(vb3 - X2*bX2)-normcdf(vb2 - X2*bX2)).^dur2_3...
           .* (normcdf(vb4 - X2*bX2)-normcdf(vb3 - X2*bX2)).^dur2_4...
           .* (normcdf(vb5 - X2*bX2)-normcdf(vb4 - X2*bX2)).^dur2_5...
           .* (normcdf(vb6 - X2*bX2)-normcdf(vb5 - X2*bX2)).^dur2_6).^(1-cens2)).*...
           ((( 1-normcdf(vb1 - X2*bX2)).^dur2_1...
           .* (1-normcdf(vb2 - X2*bX2)).^dur2_2...
           .* (1-normcdf(vb3 - X2*bX2)).^dur2_3...
           .* (1-normcdf(vb4 - X2*bX2)).^dur2_4...
           .* (1-normcdf(vb5 - X2*bX2)).^dur2_5...
           .* (1-normcdf(vb6 - X2*bX2)).^dur2_6).^cens2)).^sam2;
%--------------------------------------------------------------------------
%2.3 Contribution to the likelihood function of 3rd childbirth
%--------------------------------------------------------------------------
lf3=ones(n,1);
lf3(:,1) = ((( normcdf(vc1 - X3*bX3).^dur3_1...
           .*(normcdf(vc2 - X3*bX3)-normcdf(vc1 - X3*bX3)).^dur3_2...
           .*(normcdf(vc3 - X3*bX3)-normcdf(vc2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
          (( (1-normcdf(vc1 - X3*bX3)).^dur3_1...
          .* (1-normcdf(vc2 - X3*bX3)).^dur3_2...
          .* (1-normcdf(vc3 - X3*bX3)).^dur3_3).^cens3)).^sam3;
%--------------------------------------------------------------------------
%2.4 Contribution to the likelihood function of earnings 3 years after diploma
%--------------------------------------------------------------------------
lw3=ones(n,1);
lw3(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_1).^2)./(2.*exp(sig3)));
%--------------------------------------------------------------------------
%2.5 Contribution to the likelihood function of earnings 6 years after diploma
%--------------------------------------------------------------------------
lw6=ones(n,1);
lw6(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_1).^2)./(2.*exp(sig6)))).^samw6;
%--------------------------------------------------------------------------
%2.6 Contribution to the likelihood function of earnings 9 years after diploma
%--------------------------------------------------------------------------
lw9=ones(n,1);
lw9(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_1).^2)./(2.*exp(sig9)))).^samw9;
%--------------------------------------------------------------------------
%2.7 Contribution to the likelihood function of earnings 12 years after diploma
%--------------------------------------------------------------------------
lw12=ones(n,1);
lw12(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_1).^2)./(2.*exp(sig12)))).^samw12;
%--------------------------------------------------------------------------
%2.8 Contribution to the likelihood function of earnings 15 years after diploma
%--------------------------------------------------------------------------
lw15=ones(n,1);
lw15(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_1).^2)./(2.*exp(sig15)))).^samw15;
%--------------------------------------------------------------------------
%2.9 Contribution to the likelihood function of earnings 18 years after diploma
%--------------------------------------------------------------------------
lw18=ones(n,1);
lw18(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_1).^2)./(2.*exp(sig18)))).^samw18;
%--------------------------------------------------------------------------
%2.10 Contribution to the likelihood function of earnings 21 years after diploma
%--------------------------------------------------------------------------
lw21=ones(n,1);
lw21(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_1).^2)./(2.*exp(sig21)))).^samw21;
%--------------------------------------------------------------------------
%2.11 Contribution to the likelihood function of employment 1 year before diploma
%--------------------------------------------------------------------------
le1=ones(n,1);
le1(:,1) = (normcdf(Ze*bZe + vze_1).^emp_1).*((1-normcdf(Ze*bZe + vze_1)).^(1-emp_1));
%--------------------------------------------------------------------------
%2.12 Contribution to the likelihood function of number of siblings at 14
%--------------------------------------------------------------------------
ls1=ones(n,1);
ls1(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_1).^2)./(2.*exp(sig_zs)));
%--------------------------------------------------------------------------
%2.13 Contribution to the likelihood function of earnings 3 years after diploma
%--------------------------------------------------------------------------
lE3=ones(n,1);
lE3(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_1).^2)./(2.*exp(sigE3)));
%--------------------------------------------------------------------------
%2.14 Contribution to the likelihood function of earnings 6 years after diploma
%--------------------------------------------------------------------------
lE6=ones(n,1);
lE6(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_1).^2)./(2.*exp(sigE6)))).^samw6;
%--------------------------------------------------------------------------
%2.15 Contribution to the likelihood function of earnings 9 years after diploma
%--------------------------------------------------------------------------
lE9=ones(n,1);
lE9(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_1).^2)./(2.*exp(sigE9)))).^samw9;
%--------------------------------------------------------------------------
%2.16 Contribution to the likelihood function of earnings 12 years after diploma
%--------------------------------------------------------------------------
lE12=ones(n,1);
lE12(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_1).^2)./(2.*exp(sigE12)))).^samw12;
%--------------------------------------------------------------------------
%2.17 Contribution to the likelihood function of earnings 15 years after diploma
%--------------------------------------------------------------------------
lE15=ones(n,1);
lE15(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_1).^2)./(2.*exp(sigE15)))).^samw15;
%--------------------------------------------------------------------------
%2.18 Contribution to the likelihood function of earnings 18 years after diploma
%--------------------------------------------------------------------------
lE18=ones(n,1);
lE18(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_1).^2)./(2.*exp(sigE18)))).^samw18;
%--------------------------------------------------------------------------
%2.19 Contribution to the likelihood function of earnings 21 years after diploma
%--------------------------------------------------------------------------
lE21=ones(n,1);
lE21(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_1).^2)./(2.*exp(sigE21)))).^samw21;
%--------------------------------------------------------------------------      
%3.1 Individual contribution to the likelihood      
%--------------------------------------------------------------------------
ll(:,1)=lf1.*lf2.*lf3.*lw3.*lw6.*lw9.*lw12.*lw15.*lw18.*lw21.*le1.*ls1.*lE3.*lE6.*lE9.*lE12.*lE15.*lE18.*lE21;      
%-------------------------------------------------------------------------- 
%3.2 LOG-LIKELIHOOD FUNCTION
%--------------------------------------------------------------------------
NL = -sum(log(ll));

% %{{{Derive the score an the gradient and compute the Hessian
% [nbr,nrc]=size(b);
% 
% %read the score:
% sc = zeros(n,nbr);
% sctemp=g_tmp_log_00000;
% sc = [sctemp{:}];
% 
% %read the gradient:
% gt = zeros(nbr,1);
% gtemp= g_NL(1);
% gt=[gtemp{:}]; 
% 
% g  = gt;					%gradient
% H  = sc'*sc;				%outer product
% %}}}
% 
% %EOF
